/*****************************************************************************
 *
 *   Bundle Editor
 *
 *   Mark T. Collins,  10/19/91  2:34:41
 *   ---------------------------------------------------------------
 *   v1.0d1
 *
 *****************************************************************************/

#pragma noroot
#include <foundation.h>
#include <event.h>
#include <resources.h>

struct fOptionRec { /* Stores FST Option Group records */
    word    fsCount;
    word    fs[10];
    word    offset;
    Long    Mask;
    Long    Value;
    word    compareSpec;
};
typedef struct fOptionRec fOptionRec, *fOptionRecPtr, **fOptionRecHndl;

struct fOneDocRec { /* This is here to easily store EVERYTHING that might be */
    word    Size;
    word    OffsetToMatchFlags;
    word    NumResults;
    word    Priority;
    Long    rFinderPathID;
    Long    reserved_2;
    Long    rIconID;
    Long    reserved_3;
    Long    SmallrIconID;
    Long    reserved_4;
    char    **DocDescStrHndl;
    Long    MatchFlags;
    word    ftID;
    word    FileType;
    word    atID;
    Long    AuxType;
    Long    AuxTypeMask;
    word    fnID;
    char    **FileNameHndl;
    word    createID;
    word    CreateCompareSpec;
    TimeRec CreateTime;
    word    modID;
    word    ModCompareSpec;
    TimeRec ModTime;
    word    localID;
    word    LocalAccessMask;
    word    LocalAccess;
    word    networkID;
    word    NetworkAccessMask;
    word    NetworkAccess;
    word    extendedID;
    word    Extended;
    word    HFSftID;
    Long    HFSFileType;
    word    HFScrID;
    Long    HFSCreator;
    word    optID;
    word    OptionListCount;
    Handle  OptionHndl[1];
};
typedef struct fOneDocRec fOneDocRec, *fOneDocRecPtr, **fOneDocRecHndl;

struct fBundleRec { /* This transitory structure is here to easily store our
                        basic Bundle Stuff, and an array of the OneDocs, addressed
                        as Handles (We are good memory mongers B-) */
    word    Version;    /* Must be set to 0 */
    word    OffsetToDocumentList;  /* Currently set to    */
    Long    rIconID;    /* for the main app */
    Long    rBundleID;  /* we have to stuff the same ID the Res itself has */
    Long    AndyPriv;   /* Andy N. doesn't want us mucking with this one */
    word    DocCount;   /* This is the number of OneDocs */
    Handle  DocList[1]; /* this is an array of handles to our onedoc structures */
};
typedef struct fBundleRec fBundleRec, *fBundleRecPtr, **fBundleRecHndl;}

struct privRec {  /* this defines our Private Data Record for each session */
    Handle     h,
               theBndl;
    Long       realSize;
};
typedef struct privRec privRec, *privRecPtr, **privRecHndl;

extern EventRecordPtr fEventPtr;

word           ~TOOLERROR,          /* declared for ORCA/C toolerror()      */
               ~USERID,             /* declared for ORCA library use        */
               edUserID,
               edResFileID,
               shResFileID;

fPrivateDataRec PrivPB;
fResDataRec     DataPB;
fResData2Rec    Data2PB;
fGetFileRec     FilePB;
fResNameRec     NamePB;
fResRefRec      RefPB;
fResLinkRec     LinkPB;
fResCopyRec     CopyPB;

word REM_OPEN(fOpenRecPtr p)
{
word           retVal, retErr;
ParamListHndl  theWindow;
Handle         private;

    if (p->resType != rBundle)      /* first see if we edit this type...    */
        return fErrTypeInvalid;     /* multitype editors would case more    */

    if (!p->resID) {                /* if no ID has been passed make one... */

        CopyPB.pCount = 5;          /* in this case copy a default bundle   */
        CopyPB.resType = rBundle;
        CopyPB.resID = 2L;
        CopyPB.newID = 0L;
        CopyPB.attr = 0;
        CopyPB.resFileID = edResFileID;
        retErr = fCopyResource(&CopyPB);
        if (retErr)
            return fErrAddingResource;

        p->resID = CopyPB.resID;

    }
    DataPB.pCount = 3;              /* set up a this can be set up now because the   */
    DataPB.resType = rBundle;       /* add and load callbacks can use the   */
    DataPB.resID = p->resID;        /* same parameter block...              */
    retErr = fLoadResource(&DataPB);
    if (retErr)
        return fErrLoadingResource;
    }

    LoadHandle(rWinParam1, 1L, (Handle) theWindow);
    LoadHandle(rPString, 1L, (Handle) theWindowTitle);
    HLock(theWindowTitle);

    winP = NewWindow2(*theWindowTitle, 0L, 0L, 0L, 1, theWindow, 0x800e);
    private = NewHandle(12L, edUserID, 0x0018, 0L); /* or whatever size... */

    PrivPB.pCount = 6;
    PrivPB.winPtr = winP;
    PrivPB.remSignature = 0;
    PrivPB.Data = private;
    *(PrivRecHndl)PrivPB.Data->theBndl = NewHandle(18, edResID, 0x8018, 0x0L);
    *(PrivRecHndl)PrivPB.Data->realSize = GetHandleSize(DataPB.resData);
    *(PrivRecHndl)PrivPB.Data->h = ReadBundle (DataPB.resData,
                *(PrivRecHndl)PrivPB.Data->theBndl);
    *(PrivRecHndl)PrivPB.Data->realSize = GetHandleSize(*PrivPB.Data->h);
    PrivPB.groupSignature = 0x0020;
    PrivPB.resType = rBundle;
    PrivPB.resID = p->resID;
    fInitializePrivateData(&PrivPB);
    return  0;
}

word REM_CLOSE(fSessionRecPtr p)
{
    PrivPB.pCount = 3;
    PrivPB.winPtr = GetPort();
    fGetPrivateData(&PrivPB);
    KillHandles();
    DisposeHandle(*(PrivRecHndl)PrivPB.Data->theBndl);
    DisposeHandle(*(PrivRecHndl)PrivPB.Data->h);
    DisposeHandle(PrivPB.Data);
    if (PrivPB.winPtr)
       CloseWindow(PrivPB.winPtr);
    return  0;
}

word REM_WRITE(fSessionRecPtr p)
{
    PrivPB.pCount = 3;
    PrivPB.winPtr = p->windowPtr;
    fGetPrivateData(&PrivPB);
    *(PrivRecHndl)PrivPB.Data->h =
    StuffBundle(*(PrivRecHndl)PrivPB.Data->theBndl,
       *(PrivRecHndl)PrivPB.Data->h), *(PrivRecHndl)PrivPB.Data->realSize);

    return  0;
}

word REM_EVENT(fEventRecPtr p)
{
    return  0;  /* I don't really think I wanna do this one...  B-) */
}

word REM_ACTIVATE(fActivateRecPtr pb)
{
    return  0;
}

word REM_GETLINK(fLinkRecPtr p)
{
    return  0;
}

word REM_VIDMODE(fEventRecPtr p)
{
    return  0;     /* A Pox on 320 Mode  */
}

word REM_PRINT(fPrintRecPtr p)
{
    return  0;     /* A Bundle's a pretty damn fool thing to want to print */
}

/*
    REM_STARTUP is called only when the REM is first loaded.

    The REM should do whatever it needs to do to setup globals, etc.

    This is the only time when the Foundation and REM resource file
    ID's are passed.  Also, the REM's specific memory manager ID is
    passed here - READ THE WARNING IN REM_SHUTDOWN!

    Marc Wolfgram,  4/13/91 13:06:37
    ---------------------------------------------------------------
*/
word REM_STARTUP(fStartStopRecPtr p)
{
    ~USERID = edUserID = p->edUserID;
    edResFileID = p->edResFileID;
    shResFileID = p->shResFileID;
    return  0;
}

/*
    REM_SHUTDOWN is called when an editor is unloaded.

    WARNING: The REM must release any memory allocated at startup during
             the shutdown call.  There is no guarantee that once the editor
             is released that it will be reloaded.

    Marc Wolfgram,  4/29/91  0:33:56
    ---------------------------------------------------------------
*/
word REM_SHUTDOWN(fStartStopRecPtr p)
{
    return  0;
}

/*--------------------------------------
    LoadHandle - loads a resource from the editor's resource fork and
    returnes a detached handle for use by tool calls.
    Marc Wolfgram,  9/19/91 20:46:58
*/

word LoadHandle(word resType, long resID, Handle resData)
{
word retErr;
    DataPB.pCount = 5;
    DataPB.resType = resType;
    DataPB.resID = resID;
    DataPB.resFileID = edResFileID;
    retErr = fLoadResource(&DataPB);
    resData = DataPB.resData;
    RefPB.pCount = 3;
    RefPB.resType = resType;
    RefPB.resID = resID;
    RefPB.resFileID = edResFileID;
    fDetachResource(&RefPB);
    return retErr;
}

*****************************************************************************
*
*  Handle ReadBundle (Handle h, handle theBndl)
*
*  I suspect that Chinese Water Torture is easier (and more merciful than
*  extracting all the data from a bundle resource, but here it is).  The
*  nicest thing to say about it is that it virtually does the same thing to
*  bundle resources that Andy N did to us when he designed (is this where
*  RAND comes from?) it!!!)
*
*
*  Mark T Collins 10/19/91  13:44:14
*  inspired and shown the way by Marc Wolfgram the night before, after
*  a wonderful evening of Chuck Jones & Real Chili
*****************************************************************************

handle ReadBundle (handle h, handle theBndl)
{
Pointer         srcPtr;
fBundleRecPtr   bndlPtr;
fOneDocRecPtr   docPtr;
fOptionRecPtr   optPtr;
word            docCnt, i, j, k, strSize, optCnt;

    bndlPtr = *theBndl;
    srcPtr = *h;
    bndlPtr->Version = (word)*srcPtr;
    srcPtr += 2;
    bndlPtr->OffsetToDocumentList = (word)*srcPtr;
    srcPtr += 2;
    bndlPtr->rIconID= (long)*srcPtr;
    srcPtr += 4;
    bndlPtr->rBundleID = (long)*srcPtr;
    srcPtr += 4;
    bndlPtr->AndyPriv = (long)*srcPtr;
    srcPtr += 4;
    bndlPtr->DocCount = (word)*srcPtr;
    docCnt = bndlPtr->DocCount;
    srcPtr += 2;            /* since we now have our header info */
    HUnlock(theBndl);                           /* we unlock and resize our record Handle */
    SetHandleSize(18 + (4 * docCnt), theBndl);  /* now we have space for all docs */
    HLock(theBndl);                             /* and relock it so we can play with it */
    for (i = 0; i < docCnt; i++) {
        bndlPtr->DocList[i] = NewHandle(120, edResID, 0x8018,0x0L);
        docPtr = *bndlPtr->DocList[i]);
        docPtr->Size = (word)*srcPtr;
        srcPtr += 2;
        docPtr->OffsetToMatchFlags = (word)*srcPtr;
        srcPtr += 2;
        docPtr->NumResults = (word)*srcPtr;
        srcPtr += 2;
        docPtr->Priority = (word)*srcPtr;
        srcPtr += 2;
        if (docPtr->NumResults >= 2){
            docPtr->rFinderPathID = (long)*srcPtr;
            srcPtr += 4;
            docPtr->reserved_2 = (long)*srcPtr;
            srcPtr += 4;
        }
        if (docPtr->NumResults >= 3){
            docPtr->rIconID = (long)*srcPtr;
            srcPtr += 4;
            docPtr->reserved_3 = (long)*srcPtr;
            srcPtr += 4;
        }
        if (docPtr->NumResults >= 4){
            docPtr->SmallrIconID = (long)*srcPtr;
            srcPtr += 4;
            docPtr->reserved_4 = (long)*srcPtr;
            srcPtr += 4;
        }
        if (docPtr->NumResults >= 5){
            strSize = (char)*srcPtr;
            DocPtr->DocDescStrHndl = NewHandle(strSize, edResID, 0x8018,0x0L);
            PtrToHand(srcPtr, DocPtr->DocDescStrHndl, strSize);
            srcPtr = (Pointer) (srcPtr + 1 + strSize);
        }
        docPtr->MatchFlags = (long)*srcPtr;
        srcPtr += 4;
        if (docPtr->MatchFlags & 0x0001) {
            docPtr->ftID = (word)*srcPtr;
            srcPtr += 2;
            docPtr->FileType = (word)*srcPtr;
            srcPtr += 2;
        }
        if (docPtr->MatchFlags & 0x0002) {
            docPtr->atID = (word)*srcPtr;
            srcPtr += 2;
            docPtr->AuxTypeMask = (long)*srcPtr;
            srcPtr += 4;
            docPtr->AuxType = (long)*srcPtr;
            srcPtr += 4;
        }
        if (docPtr->MatchFlags & 0x0004) {
            docPtr->fnID = (word)*srcPtr;
            srcPtr += 2;
            strSize = (char)*srcPtr;
            DocPtr->FileNameHndl = NewHandle(strSize, edResID, 0x8018,0x0L);
            PtrToHand(srcPtr, DocPtr->FileNameHndl, strSize);
            srcPtr = (Pointer) (srcPtr + 1 + strSize);
        }
        if (docPtr->MatchFlags & 0x0008) {
            docPtr->createID = (word)*srcPtr;
            srcPtr += 2;
            docPtr->CreateCompareSpec = (word)*srcPtr;
            srcPtr += 2;
            docPtr->CreateTime = (TimeRec)*srcPtr;
            srcPtr += 8;
        }
        if (docPtr->MatchFlags & 0x0010) {
            docPtr->modID = (word)*srcPtr;
            srcPtr += 2;
            docPtr->ModCompareSpec = (word)*srcPtr;
            srcPtr += 2;
            docPtr->ModTime = (TimeRec)*srcPtr;
            srcPtr += 8;
        }
        if (docPtr->MatchFlags & 0x0020) {
            docPtr->localID = (word)*srcPtr;
            srcPtr += 2;
            docPtr->LocalAccessMask = (word)*srcPtr;
            srcPtr += 2;
            docPtr->LocalAccess = (TimeRec)*srcPtr;
            srcPtr += 2;
        }
        if (docPtr->MatchFlags & 0x0040) {
            docPtr->networkID = (word)*srcPtr;
            srcPtr += 2;
            docPtr->NetworkAccessMask = (long)*srcPtr;
            srcPtr += 4;
            docPtr->NetworkAccess = (long)*srcPtr;
            srcPtr += 4;
        }
        if (docPtr->MatchFlags & 0x0080) {
            docPtr->extendedID = (word)*srcPtr;
            srcPtr += 2;
            docPtr->Extended = (word)*srcPtr;
            srcPtr += 2;
        }
        if (docPtr->MatchFlags & 0x0100) {
            docPtr->HFSftID = (word)*srcPtr;
            srcPtr += 2;
            docPtr->HFSFileType = (long)*srcPtr;
            srcPtr =+ 4;
        }
        if (docPtr->MatchFlags & 0x0200) {
            docPtr->HFScrID = (word)*srcPtr;
            srcPtr += 2;
            docPtr->HFSCreator = (long)*srcPtr;
            srcPtr += 4;
        }
        if (docPtr->MatchFlags & 0x0400) {
            docPtr->optID = (word)*srcPtr;
            srcPtr += 2;
            docPtr->OptionListCount = (word)*srcPtr;
            optCnt = docPtr->OptionListCount;
            srcPtr += 2;
            if (docPtr->OptionListCount) {
                HUnlock(docPtr);
                SetHandleSize(80 + (4 * optCnt), docPtr);
                HLock(docPtr);
                for (j = 0; j < optCnt; j++) {
                    docPtr->OptionHndl[j] = NewHandle(34, edResID, 0x8018,0x0L);
                    OptPtr =(fOptionRecPtr) *(docPtr->OptionHndl[j]);
                    OptPtr->fsCount = (word)*srcPtr;
                    srcPtr += 2;
                    for (k = 0; k < OptPtr->fsCount; k++){
                        OptPtr->fs[k] = (word)*srcPtr;
                        srcPtr += 2;
                    }
                    OptPtr->offset = (word)*srcPtr;
                    srcPtr += 2;
                    OptPtr->Mask = (Long)*srcPtr;
                    srcPtr += 4;
                    OptPtr->Value = (Long)*srcPtr;
                    srcPtr += 4;
                    OptPtr->compareSpec = (word)*srcPtr;
                    srcPtr += 2;
                    HUnlock(OptPtr->OptionHndl[j]);
                }
            }
        }
        HUnlock(bndlPtr->DocList[i]);
    }
    HUnlock(theBndl);
    HUnlock(h);
    return theBndl;
}

*****************************************************************************
*
*  Handle StuffBundle (Handle theBndl, handle h, long workSize)
*
*  Well, they say all the king's horses, and all the king's men...
*  but here is the Bundle, together again...
*  The NeXT time Andy designs something like this, move him to the Mac
*  tools group, where they're too numb to know what hit them!
*
*  Mark T Collins 10/19/91  13:44:14
*  inspired and shown the way by Marc Wolfgram the night before
*  (the RealChili is STILL working, over 12 hours later!!!!  SHEESH!!!)
*****************************************************************************

handle StuffBundle (handle theBndl, handle h, long workSize)
{
Pointer         srcPtr;
fBundleRecPtr   bndlPtr;
fOneDocRecPtr   docPtr;
fOptionRecPtr   optPtr;
word            docCnt, i, j, k, optCnt;
long            strSize;

    Hlock(theBndl);
    bndlPtr = *theBndl;
    SetHandleSize(workSize, h);
    HLock(h);
    srcPtr = *h;
    (word)*srcPtr = bndlPtr->Version;
    srcPtr += 2;
    (word)*srcPtr = bndlPtr->OffsetToDocumentList;
    srcPtr += 2;
    (long)*srcPtr = bndlPtr->rIconID;
    srcPtr += 4;
    (long)*srcPtr = bndlPtr->rBundleID;
    srcPtr += 4;
    (long)*srcPtr = bndlPtr->AndyPriv;
    srcPtr += 4;
    (word)*srcPtr = bndlPtr->DocCount;
    docCnt = bndlPtr->DocCount;
    srcPtr += 2;
    for (i = 0; i < docCnt; i++) {
        docPtr = *DocList[i];
        (word)*srcPtr = docPtr->Size;
        srcPtr += 2;
        (word)*srcPtr = docPtr->OffsetToMatchFlags;
        srcPtr += 2;
        (word)*srcPtr = docPtr->NumResults;
        srcPtr += 2;
        (word)*srcPtr = docPtr->Priority;
        srcPtr += 2;
        if (docPtr->NumResults >= 2){
            (long)*srcPtr = docPtr->rFinderPathID;
            srcPtr += 4;
            (long)*srcPtr = docPtr->reserved_2;
            srcPtr += 4;
        }
        if (docPtr->NumResults >= 3){
            (long)*srcPtr = docPtr->rIconID;
            srcPtr += 4;
            (long)*srcPtr = docPtr->reserved_3;
            srcPtr += 4;
        }
        if (docPtr->NumResults >= 4){
            (long)*srcPtr = docPtr->SmallrIconID;
            srcPtr += 4;
            (long)*srcPtr = docPtr->reserved_3;
            srcPtr += 4;
        }
        if (docPtr->NumResults >= 5){
            strSize = GetHandleSize(DocPtr->DocDescStrHndl);
            HandToPtr(DocPtr->DocDescStrHndl,srcPtr, strSize);
            srcPtr += strSize;
        }
        (long)*srcPtr = docPtr->MatchFlags;
        srcPtr += 4;
        if (docPtr->MatchFlags & 0x0001) {
            (word)*srcPtr = docPtr->ftID;
            srcPtr += 2;
            (word)*srcPtr = docPtr->FileType;
            srcPtr += 2;
        }
        if (docPtr->MatchFlags & 0x0002) {
            (word)*srcPtr = docPtr->atID;
            srcPtr += 2;
            (long)*srcPtr = docPtr->AuxTypeMask;
            srcPtr += 4;
            (long)*srcPtr = docPtr->AuxType;
            srcPtr += 4;
        }
        if (docPtr->MatchFlags & 0x0004) {
            (word)*srcPtr = docPtr->fnID;
            srcPtr += 2;
            strSize = GetHandleSize(DocPtr->FileNameHndl);
            HandToPtr(DocPtr->FileNameHndl, srcPtr, strSize);
            srcPtr += strSize;
        }
        if (docPtr->MatchFlags & 0x0008) {
            (word)*srcPtr = docPtr->createID;
            srcPtr += 2;
            (word)*srcPtr = docPtr->CreateCompareSpec;
            srcPtr += 2;
            (TimeRec)*srcPtr = docPtr->CreateTime;
            srcPtr += 8;
        }
        if (docPtr->MatchFlags & 0x0010) {
            (word)*srcPtr = docPtr->modID;
            srcPtr += 2;
            (word)*srcPtr = docPtr->ModCompareSpec;
            srcPtr += 2;
            (TimeRec)*srcPtr = docPtr->ModTime;
            srcPtr += 8;
        }
        if (docPtr->MatchFlags & 0x0020) {
            (word)*srcPtr = docPtr->localID;
            srcPtr += 2;
            (word)*srcPtr = docPtr->LocalAccessMask;
            srcPtr += 2;
            (TimeRec)*srcPtr = docPtr->LocalAccess;
            srcPtr += 2;
        }
        if (docPtr->MatchFlags & 0x0040) {
            (word)*srcPtr = docPtr->networkID;
            srcPtr += 2;
            (long)*srcPtr = docPtr->NetworkAccessMask;
            srcPtr += 4;
            (long)*srcPtr = docPtr->NetworkAccess;
            srcPtr += 4;
        }
        if (docPtr->MatchFlags & 0x0080) {
            (word)*srcPtr = docPtr->extendedID;
            srcPtr += 2;
            (word)*srcPtr = docPtr->Extended;
            srcPtr += 2;
        }
        if (docPtr->MatchFlags & 0x0100) {
            (word)*srcPtr = docPtr->HFSftID;
            srcPtr += 2;
            (long)*srcPtr = docPtr->HFSFileType;
            srcPtr +=4;
        }
        if (docPtr->MatchFlags & 0x0200) {
            (word)*srcPtr = docPtr->HFScrID;
            srcPtr += 2;
            (long)*srcPtr = docPtr->HFSCreator;
            srcPtr += 4;
        }
        if (docPtr->MatchFlags & 0x0400) {
            (word)*srcPtr = docPtr->optID;
            srcPtr += 2;
            (word)*srcPtr = docPtr->OptionListCount;
            optCnt = docPtr->OptionListCount;
            srcPtr += 2;
            if (docPtr->OptionListCount) {
                for (j = 0; j < optCnt; j++) {
                    OptionHndl[j] = NewHandle(34, edResID, 0x8018,0x0L);
                    OptPtr =(fOptionRecPtr) *(docPtr->OptionHndl[j]);
                    (word)*srcPtr = OptPtr->fsCount;
                    srcPtr += 2;
                    for (k = 0; k < OptPtr->fsCount; k++){
                        (word)*srcPtr = OptPtr->fs[k];
                        srcPtr += 2;
                    }
                    (word)*srcPtr = OptPtr->offset;
                    srcPtr += 2;
                    (Long)*srcPtr = OptPtr->Mask;
                    srcPtr += 4;
                    (Long)*srcPtr = OptPtr->Value;
                    srcPtr += 4;
                    (word)*srcPtr = OptPtr->compareSpec;
                    srcPtr += 2;
                    HUnlock(OptPtr->OptionHndl[j]);
                }
            }
        }
        HUnlock(bndlPtr->DocList[i]);
    }
    HUnlock(theBndl);
    HUnlock(h);
    return h;
}

*****************************************************************************
*
*  void KillHandles (void)
*
*  See, we are good Toolbox citizens...
*  We put our toys away when we are through with them....
*  This makes it easier...
*
*  Mark T Collins 10/19/91  14:15:22
*  To Paraphrase Dr. Seuss...  "I did it ALL by myself....
*                                  which mean's it's probably FOOBARed"
*****************************************************************************

void KillHandles (void)
{
Handle          SlightHand;
Pointer         srcPtr;
fBundleRecPtr   bndlPtr;
fOneDocRecPtr   docPtr;
fOptionRecPtr   optPtr;
word            docCnt, i, j, k, strSize, optCnt;
    SlightHand = *(PrivRecHndl)PrivPB.Data->theBndl;
    bndlPtr = *SlightHand;
    docCnt = bndlPtr->DocCount;
    for (i = 0; i < docCnt; i++) {
        DisposeHandle(bndlPtr->DocList[i]);
        docPtr = *bndlPtr->DocList[i]);
        if (docPtr->NumResults >= 5){
            DisposeHandle(DocPtr->DocDescStrHndl);
        if (docPtr->MatchFlags & 0x0004) {
            DisposeHandle(DocPtr->FileNameHndl);
        if (docPtr->MatchFlags & 0x0400) {
            docPtr->OptionListCount = (word)*srcPtr;
            optCnt = docPtr->OptionListCount;
            if (docPtr->OptionListCount) {
                for (j = 0; j < optCnt; j++) {
                    DisposeHandle(docPtr->OptionHndl[j]);
                }
            }
        }
    }
}
